{********************************************
; File: TextEdit.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT TEXTEDIT;

INTERFACE

USES TYPES,QUICKDRAW,EVENTS,FONTS,GSOS,RESOURCES,CONTROLS;

CONST
{ Error Codes }
teAlreadyStarted = $2201;
teNotStarted = $2202;
teInvalidHandle = $2203;
teInvalidVerb = $2204;
teInvalidFlag = $2205;
teInvalidPCount = $2206;
teInvalidRect = $2207;
teBufferOverflow = $2208;
teInvalidLine = $2209;
teInvalidCall = $220A;

{ TE Verbs }
NullVerb = $0000;
PStringVerb = $0001;
CStringVerb = $0002;
C1InputVerb = $0003;
C1OutputVerb = $0004;
HandleVerb = $0005;
PointerVerb = $0006;
NewPStringVerb = $0007;
fEqualLineSpacing = $8000;
fShowInvisibles = $4000;
teInvalidDescriptor = $2204;
teInvalidParameter = $220B;
teInvalidTextBox2 = $220C;
teNeedsTools = $220D;
teEqualLineSpacing = $8000;
teShowInvisibles = $4000;

{ Justification Values }
leftJust = $0000;
rightJust = $FFFF;
centerJust = $0001;
fullJust = $0002;

{ TERuler.tabType Codes }
noTabs = $0000;
stdTabs = $0001;  { Tabs every tabTerminator pixels }
absTabs = $0002;  { Tabs at absolute location specified by theTabs array }

{ TEParamBlock.flags Codes }
fCtlInvis = $0080;
fRecordDirty = $0040;

{ TE Tab Codes }
teLeftTab = $0000;
teCenterTab = $0001;
teRightTab = $0002;
teDecimalTab = $0003;

{ TEParamBlock.textFlags Codes }
fNotControl = $80000000;  { TextEdit record is not a control }
fSingleFormat = $40000000;  { Only one ruler is allowed for record }
fSingleStyle = $20000000;  { Only one style is allowed for record }
fNoWordWrap = $10000000;  { No word wrap is performed }
fNoScroll = $08000000;  { The text cannot scroll }
fReadOnly = $04000000;  { The text cannot be edited }
fSmartCutPaste = $02000000;  { Record supports intelligent cut and paste }
fTabSwitch = $01000000;  { Tab key switches user to next TextEdit record on the screen }
fDrawBounds = $00800000;  { TextEdit draw a box around text }
fColorHilight = $00400000;  { Use color table for highlighting }
fGrowRuler = $00200000;  { Adjust right margin whenever window size changes }
fDisableSelection = $00100000;  { User cannot select or edit text }
fDrawInactiveSelection = $00080000;  { TextEdit displays a box around an inactive selection }

{ Descriptor Codes }
teCtlColorIsPtr = $0000;
teCtlColorIsHandle = $0004;
teCtlColorIsResource = $0008;
teCtlStyleIsPtr = $0000;
teCtlStyleIsHandle = $0001;
teCtlStyleIsResource = $0002;
teRefIsPtr = $0000;
teRefIsHandle = $0001;
teRefIsResource = $0002;
teRefIsNewHandle = $0003;
teDataIsPString = $0000;
teDataIsCString = $0001;
teDataIsC1Input = $0002;
teDataIsC1Output = $0003;
teDataIsTextBox2 = $0004;
teDataIsTextBlock = $0005;
teTextIsPtr = $0000;
teTextIsHandle = $0008;
teTextIsResource = $0010;
teTextIsNewHandle = $0018;

{ TEGetLastError clearFlag Codes }
fLeaveError = $0000;  { Leave the last error code intact }
fClearError = $FFFF;  { Clear the last error code }

{ Other Constants }
teInvis = $4000;
tePartialLines = $8000;
teDontDraw = $4000;
teUseFont = $0020;
teUseSize = $0010;
teUseForeColor = $0008;
teUseBackColor = $0004;
teUseUserData = $0002;
teUseAttributes = $0001;
teReplaceFont = $0040;
teReplaceSize = $0020;
teReplaceForeColor = $0010;
teReplaceBackColor = $0008;
teReplaceUserField = $0004;
teReplaceAttributes = $0002;
teSwitchAttributes = $0001;

{ Filter Procedure Commands }
doEraseRect = $0001;
doEraseBuffer = $0002;
doRectChanged = $0003;
doKeyStroke = $0004;

{ TEScroll descriptors }
teScrollAbsTop = $0000;
teScrollAbsCenter = $0001;
teScrollLineTop = $0002;
teScrollLineCenter = $0003;
teScrollAbsUnit = $0004;
teScrollRelUnit = $0005;

TYPE

TETextBlockHndl = ^TETextBlockPtr;
TETextBlockPtr = ^TETextBlock;
TETextBlock = RECORD
    nextHandle : TETextBlockHndl; { Handle to next TextBlock in list }
    prevHandle : TETextBlockHndl; { Handle to previous TextBlock in list }
    textLength : Longint; { Number of bytes of theText }
    flags : Integer;
    reserved : Integer; { Reserved }
    theText : PACKED ARRAY[1..1] OF Byte; { textLength bytes of text  }
END;

TETextListHndl = ^TETextListPtr;
TETextListPtr = ^TETextList;
TETextList = RECORD
    cachedHandle : TETextBlockHndl; { Handle to current TextBlock }
    cachedOffset : Longint; { Text offset of the start of the current TextBlock }
END;

TEColorTableHndl = ^TEColorTablePtr;
TEColorTablePtr = ^TEColorTable;
TEColorTable = RECORD
    contentColor : Integer;
    outlineColor : Integer;
    hiliteForeColor : Integer;
    hiliteBackColor : Integer;
    vertColorDescriptor : Integer;
    vertColorRef : Longint;
    horzColorDescriptor : Integer;
    horzColorRef : Longint;
    growColorDescriptor : Integer;
    growColorRef : Longint;
END;

TEBlockEntry = RECORD
    text : Handle;
    length : Handle;
    flags : Integer;
END;

TEBlocksHndl = ^TEBlocksPtr;
TEBlocksPtr = ^TEBlocksRecord;
TEBlocksRecord = RECORD
    start : Longint;
    index : Integer;
    blocks : ARRAY[1..1] OF TEBlockEntry;
END;

TabItem = RECORD
    tabKind : Integer;
    tabData : Integer;
END;

TESuperItemHndl = ^TESuperItemPtr;
TESuperItemPtr = ^TESuperItem;
TESuperItem = RECORD
    itemLength : Longint;
    itemData : Longint;
END;

TESuperBlockHndl = ^TESuperBlockPtr;
TESuperBlockPtr = ^TESuperBlock;
TESuperBlock = RECORD
    nextHandle : TESuperBlockHndl;
    prevHandle : TESuperBlockHndl;
    textLength : Longint;
    reserved : Longint;
    theItems : ARRAY[1..1] OF TESuperItem;
END;

TESuperHandleHndl = ^TESuperHandlePtr;
TESuperHandlePtr = ^TESuperHandle;
TESuperHandle = RECORD
    cachedHandle : TESuperBlockHndl;
    cachedOffset : Longint;
    cachedIndex : Integer;
    itemsPerBlock : Integer;
END;

TERulerHndl = ^TERulerPtr;
TERulerPtr = ^TERuler;
TERuler = RECORD
    leftMargin : Integer;
    leftIndent : Integer;
    rightMargin : Integer;
    just : Integer;
    extraLS : Integer;
    flags : Integer;
    userData : Longint;
    tabType : Integer;
    theTabs : ARRAY[1..1] OF TabItem;
    tabTerminator : Integer;
END;

TEStyleHndl = ^TEStylePtr;
TEStylePtr = ^TEStyle;
TEStyle = RECORD
    styleFontID : FontID;
    foreColor : Integer;
    backColor : Integer;
    userData : Longint;
END;

TEStyleGroupHndl = ^TEStyleGroupPtr;
TEStyleGroupPtr = ^TEStyleGroup;
TEStyleGroup = RECORD
    count : Integer;
    styles : ARRAY[1..1] OF TEStyle;
END;

StyleItemHndl = ^StyleItemPtr;
StyleItemPtr = ^StyleItem;
StyleItem = RECORD
    dataLength : Longint; { Number of text characters using the style }
    dataOffset : Longint; { Byte offset into theStyleList entry }
END;

TERulerRef = RECORD CASE INTEGER OF
     teRefIsPtr: (refIsPtr: TERulerPtr);
     teRefIsHandle: (refIsHandle: TERulerHndl);
     teRefIsResource: (refIsResource: ResID);
     teRefIsNewHandle: (refIsNewHandle: ^TERulerHndl);
END;


{
    The following data structure (TEFormat) is for reference only!
    It contains embedded variable length fields.
}

TEFormatHndl = ^TEFormatPtr;
TEFormatPtr = ^TEFormat;
TEFormat = RECORD
    version : Integer;
    rulerListLength : Longint;
    theRulerList : ARRAY[1..1] OF TERuler;
    styleListLength : Longint;
    theStyleList : ARRAY[1..1] OF TEStyle;
    numberOfStyles : Longint;
    theStyles : ARRAY[1..1] OF StyleItem;
END;

TETextRef = RECORD CASE INTEGER OF
     $0000:(textIsPStringPtr:StringPtr);
     $0001:(textIsCStringPtr:CStringPtr);
     $0002:(textIsC1InputPtr:GSString255Ptr);
     $0003:(textIsC1OutputPtr:ResultBuf255Ptr);
     $0004:(textIsTB2Ptr:Ptr);
     $0005:(textIsRawPtr:Ptr);

     $0008:(textIsPStringHandle:String255Hndl);
     $0009:(textIsCStringHandle:CStringHndl);
     $000A:(textIsC1InputHandle:GSString255Hndl);
     $000B:(textIsC1OutputHandle:ResultBuf255Hndl);
     $000C:(textIsTB2Handle:Handle);
     $000D:(textIsRawHandle:Handle);

     $0010:(textIsPStringResource: ResID);
     $0011:(textIsCStringResource: ResID);
     $0012:(textIsC1InputResource: ResID);
     $0013:(textIsC1OutputResource: ResID);
     $0014:(textIsTB2Resource: ResID);
     $0015:(textIsRawResource: ResID);

     $0018:(textIsPStringNewH:String255HndlPtr);
     $0019:(textIsCStringNewH:CStringHndlPtr);
     $001A:(textIsC1InputNewH:GSString255HndlPtr);
     $001B:(textIsC1OutputNewH:ResultBuf255HndlPtr);
     $001C:(textIsTB2NewH:HandlePtr);
     $001D:(textIsRawNewH:HandlePtr);
END;

TEStyleRef = RECORD CASE INTEGER OF
     $0000:(styleIsPtr:TEFormatPtr);
     $0001:(styleIsHandle:TEFormatHndl);
     $0002:(styleIsResource:ResID);
     $0003:(styleIsNewH:^TEFormatHndl);
END;

TEColorRef = RECORD CASE INTEGER OF
     $0000:(colorIsPtr: TEColorTablePtr);
     $0004:(colorIsHandle: TEColorTableHndl);
     $0008:(colorIsResource: ResID);
END;

TEParamBlockHndl = ^TEParamBlockPtr;
TEParamBlockPtr = ^TEParamBlock;
TEParamBlock = RECORD
    pCount : Integer;
    controlID : Longint;
    boundsRect : Rect;
    procRef : Longint;
    flags : Integer;
    moreflags : Integer;
    refCon : Longint;
    textFlags : Longint;
    indentRect : Rect;
    vertBar : CtlRecHndl;
    vertAmount : Integer;
    horzBar : CtlRecHndl;
    horzAmount : Integer;
    styleRef : TEStyleRef;
    textDescriptor : Integer;
    textRef : TETextRef;
    textLength : Longint;
    maxChars : Longint;
    maxLines : Longint;
    maxCharsPerLine : Integer;
    maxHeight : Integer;
    colorRef : TEColorRef;
    drawMode : Integer;
    filterProcPtr : ProcPtr;
END;

TEInfoRec = RECORD
    charCount : Longint;
    lineCount : Longint;
    formatMemory : Longint;
    totalMemory : Longint;
    styleCount : Longint;
    rulerCount : Longint;
END;

TEHooks = RECORD
    charFilter : ProcPtr;
    wordWrap : ProcPtr;
    wordBreak : ProcPtr;
    drawText : ProcPtr;
    eraseText : ProcPtr;
END;

TEKeyRecordHndl = ^TEKeyRecordPtr;
TEKeyRecordPtr = ^TEKeyRecord;
TEKeyRecord = RECORD
    theChar : Integer;
    theModifiers : Integer;
    theInputHandle : Handle;
    cursorOffset : Longint;
    theOpCode : Integer;
END;

TERecordHndl = ^TERecordPtr;
TERecordPtr = ^TERecord;
TERecord = PACKED RECORD
    ctrlNext : CtlRecHndl;
    inPort : WindowPtr;
    boundsRect : Rect;
    ctrlFlag : Byte;
    ctrlHilite : Byte;
    lastErrorCode : Integer;
    ctrlProc : ProcPtr;
    ctrlAction : ProcPtr;
    filterProc : ProcPtr;
    ctrlRefCon : Longint;
    colorRef : TEColorTablePtr;
    textFlags : Longint;
    textLength : Longint;
    blockList : TETextList;
    ctrlID : Longint;
    ctrlMoreFlags : Integer;
    ctrlVersion : Integer;
    viewRect : Rect;
    totalHeight : Longint;
    lineSuper : TESuperHandle;
    styleSuper : TESuperHandle;
    styleList : Handle;
    rulerList : Handle;
    lineAtEndFlag : Boolean;
    selectionStart : Longint;
    selectionEnd : Longint;
    selectionActive : Integer;
    selectionState : Integer;
    caretTime : Longint;
    nullStyleActive : Boolean;
    nullStyle : TEStyle;
    topTextOffset : Longint;
    topTextVPos : Integer;
    vertScrollBar : CtlRecHndl;
    vertScrollPos : Longint;
    vertScrollMax : Longint;
    vertScrollAmount : Integer;
    horzScrollBar : CtlRecHndl;
    horzScrollPos : Longint;
    horzScrollMax : Longint;
    horzScrollAmount : Integer;
    growBoxHandle : CtlRecHndl;
    maximumChars : Longint;
    maximumLines : Longint;
    maxCharsPerLine : Integer;
    maximumHeight : Integer;
    textDrawMode : Integer;
    wordBreakHook : ProcPtr;
    wordWrapHook : ProcPtr;
    keyFilter : ProcPtr;
    theFilterRect : Rect;
    theBufferVPos : Integer;
    theBufferHPos : Integer;
    theKeyRecord : TEKeyRecord;
    cachedSelcOffset : Longint;
    cachedSelcVPos : Integer;
    cachedSelcHPos : Integer;
    mouseRect : Rect;
    mouseTime : Longint;
    mouseKind : Integer;
    lastClick : Point;
    savedHPos : Integer;
    anchorPoint : Longint;
END;

PROCEDURE TEActivate ( teH:TERecordHndl)  ;
PROCEDURE TEBootInit   ;
PROCEDURE TEClear ( teH:TERecordHndl)  ;
PROCEDURE TEClick (VAR theEventPtr:EventRecord; teH:TERecordHndl)  ;
PROCEDURE TECompactRecord ( teH:TERecordHndl)  ;
PROCEDURE TECopy ( teH:TERecordHndl)  ;
PROCEDURE TECut ( teH:TERecordHndl)  ;
PROCEDURE TEDeactivate ( teH:TERecordHndl)  ;
FUNCTION TEGetDefProc  : ProcPtr ;
FUNCTION TEGetInternalProc  : ProcPtr ;
FUNCTION  TEGetLastError ( clearFlag:Integer; teH:TERecordHndl) : Integer ;
PROCEDURE TEGetRuler ( rulerDescriptor:Integer; rulerRef:TERulerRef; teH:TERecordHndl)  ;
PROCEDURE TEGetSelection (VAR selStart:Longint;VAR selEnd:Longint; teH:TERecordHndl)  ;
FUNCTION  TEGetSelectionStyle (VAR commonStyle:TEStyle; styleHandle:TEStyleGroupHndl; teH:TERecordHndl) : Integer ;
FUNCTION  TEGetText ( bufferDesc:Integer; bufferRef:TETextRef; bufferLength:Longint; styleDesc:Integer; styleRef:TEStyleRef; teH:TERecordHndl) : Longint ;
PROCEDURE TEGetTextInfo (VAR infoRec:TEInfoRec; pCount:Integer; teH:TERecordHndl)  ;
PROCEDURE TEIdle ( teH:TERecordHndl)  ;
PROCEDURE TEInsert ( textDesc:Integer; textRef:TETextRef; textLength:Longint; styleDesc:Integer; styleRef:TEStyleRef; teH:TERecordHndl)  ;
PROCEDURE TEInsertPageBreak ( teH:TERecordHndl)  ;
PROCEDURE TEKey ( theEventPtr:EventRecord; teH:TERecordHndl)  ;
PROCEDURE TEKill ( teH:TERecordHndl)  ;
FUNCTION  TENew ( theParms:TEParamBlock) : TERecordHndl ;
PROCEDURE TEOffsetToPoint ( textOffset:Longint;VAR vertPos:Longint;VAR horzPos:Longint; teH:TERecordHndl)  ;
FUNCTION  TEPaintText ( thePort:GrafPortPtr; start:Longint; destRect:rect; paintFlags:Integer; teH:TERecordHndl) : Longint ;
PROCEDURE TEPaste ( teH:TERecordHndl)  ;
FUNCTION  TEPointToOffset ( vertPos:Longint; horzPos:Longint; teH:TERecordHndl) : Longint ;
PROCEDURE TEReplace ( textDesc:Integer; textRef:TETextRef; textLength:Longint; styleDesc:Integer; styleRef:TEStyleRef; teH:TERecordHndl)  ;
PROCEDURE TEReset   ;
PROCEDURE TEScroll ( scrollDescriptor:Integer; vertAmount:Longint; horzAmount:Longint; teH:TERecordHndl)  ;
PROCEDURE TESetRuler ( rulerDescriptor:Integer; rulerRef:TERulerRef; teH:TERecordHndl)  ;
PROCEDURE TESetSelection ( selStart:Longint; selEnd:Longint; teH:TERecordHndl)  ;
PROCEDURE TESetText ( textDesc:Integer; textRef:TETextRef; textLength:Longint; styleDesc:Integer; styleRef:TEStyleRef; teH:TERecordHndl)  ;
PROCEDURE TEShutDown   ;
PROCEDURE TEStartUp ( userId:Integer; directPage:Integer)  ;
FUNCTION TEStatus  : Integer ;
PROCEDURE TEStyleChange ( flags:Integer; newStyle:TEStyle; teH:TERecordHndl)  ;
PROCEDURE TEUpdate ( teH:TERecordHndl)  ;
FUNCTION TEVersion  : Integer ;

IMPLEMENTATION

END.
